/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.autocorrect.tweaker;

import club.sk1er.autocorrect.tweaker.transform.GuiChatTransformer;
import club.sk1er.autocorrect.tweaker.transform.GuiTextFieldTransformer;
import club.sk1er.autocorrect.tweaker.transform.ITransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"AutoCorrect");
    private final Multimap<String, ITransformer> transformerMap = ArrayListMultimap.create();

    public ClassTransformer() {
        this.registerTransformer(new GuiChatTransformer());
        this.registerTransformer(new GuiTextFieldTransformer());
    }

    private void registerTransformer(ITransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = this.transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        LOGGER.info("Found {} transformers for {}", new Object[]{transformers.size(), transformedName});
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 8);
        transformers.forEach(transformer -> {
            LOGGER.info("Applying transformer {} on {}...", new Object[]{transformer.getClass().getName(), transformedName});
            transformer.transform(node, transformedName);
        });
        ClassWriter writer = new ClassWriter(3);
        try {
            node.accept((ClassVisitor)writer);
        }
        catch (Throwable t) {
            LOGGER.error("Exception when transforming " + transformedName + " : " + t.getClass().getSimpleName());
            t.printStackTrace();
        }
        return writer.toByteArray();
    }
}

